<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Book extends Model 
{

    protected $table = 'books';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function teachingMeterial()
    {
        return $this->belongsTo('App\Models\TeachingMeterial');
    }

    public function sections()
    {
        return $this->hasMany('App\Models\Section');
    }

    public function units()
    {
        return $this->hasMany('App\Models\Unit');
    }

}